% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R, R/Result.R
\docType{methods}
\name{dbIsValid}
\alias{dbIsValid}
\alias{dbIsValid,AthenaConnection-method}
\alias{dbIsValid,AthenaResult-method}
\title{Is this DBMS object still valid?}
\usage{
\S4method{dbIsValid}{AthenaConnection}(dbObj, ...)

\S4method{dbIsValid}{AthenaResult}(dbObj, ...)
}
\arguments{
\item{dbObj}{An object inheriting from \linkS4class{DBIObject},
i.e. \linkS4class{DBIDriver}, \linkS4class{DBIConnection},
or a \linkS4class{DBIResult}}

\item{...}{Other arguments to methods.}
}
\value{
\code{dbIsValid()} returns logical scalar, \code{TRUE} if the object (\code{dbObj}) is valid, \code{FALSE} otherwise.
}
\description{
This method tests whether the \code{dbObj} is still valid.
}
\examples{
\donttest{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `noctua::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(noctua::athena())

# Check is connection is valid
dbIsValid(con)

# Check is query is valid
res <- dbSendQuery(con, "show databases")
dbIsValid(res)

# Check if query is valid after clearing result
dbClearResult(res)
dbIsValid(res)

# Check if connection if valid after closing connection
dbDisconnect(con)
dbIsValid(con)
}
}
\seealso{
\code{\link[DBI]{dbIsValid}}
}
