% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\docType{methods}
\name{dbRemoveTable}
\alias{dbRemoveTable}
\alias{dbRemoveTable,AthenaConnection,character-method}
\title{Remove table from Athena}
\usage{
\S4method{dbRemoveTable}{AthenaConnection,character}(conn, name, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{A character string specifying a DBMS table name.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbRemoveTable()} returns \code{TRUE}, invisibly.
}
\description{
Removes Athena table but does not remove the data from Amazon S3 bucket.
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `noctua::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(noctua::athena())

# Write data.frame to Athena table
dbWriteTable(con, "mtcars", mtcars,
             partition=c("TIMESTAMP" = format(Sys.Date(), "\%Y\%m\%d")),
             s3.location = "s3://mybucket/data/")
             
# Remove Table from Athena
dbRemoveTable(con, "mtcars")

# Disconnect conenction
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{dbRemoveTable}}
}
