% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{rnonRLIII}
\alias{rnonRLIII}
\title{Type III Non-Random Labeling of a Given Set of Points}
\usage{
rnonRLIII(dat, prop, rho, pow, rand.init = TRUE, poisson = FALSE)
}
\arguments{
\item{dat}{A set of points the non-RL procedure is applied to obtain cases and controls randomly in the 
type III fashion (see the description).}

\item{prop}{A real number between 0 and 1 (inclusive) representing the proportion of new cases (on the average)
infected by the initial case, i.e., number of newly infected cases (in addition to the first case) is Poisson
with \code{mean=round(n*prop)} where \eqn{n} is the number of points in \code{dat}, if the argument \code{poisson=TRUE}, else it is \code{round(n*prop)}.}

\item{rho}{A scaling parameter for the probabilities of labeling the points as cases
(see the description).}

\item{pow}{A parameter in the power adjusting the distance dependence in the probabilities of labeling the
points as cases (see the description).}

\item{rand.init}{A logical argument (default is \code{TRUE}) to determine the choice of the initial case in the data set, \code{dat}.
If \code{rand.init=TRUE} then the initial case is selected randomly from the data points, and if \code{rand.init=}
\code{FALSE}, the first entry in the data set, \code{dat}, is labeled as the initial case.}

\item{poisson}{A logical argument (default is \code{FALSE}) to determine whether the number of cases \eqn{n_1},
will be random or fixed. If \code{poisson=TRUE} then the \eqn{n_1} is from a Poisson distribution, 
\eqn{n_1=}\code{rpois(1,round(n*prop,0))} otherwise it is fixed, \eqn{n_1=}\code{round(n*prop,0)}.}
}
\value{
A \code{list} with the elements
\item{pat.type}{\code{="cc"} for the case-control patterns for RL or non-RL of the given data points, \code{dat}}
\item{type}{The type of the point pattern}
\item{parameters}{rho and pow, where \code{rho} is the scalign parameter and \code{pow} is the parameter in the power
adjusting the distance dependence in probabilities of labeling the points as cases.}
\item{dat.points}{The set of points non-RL procedure is applied to obtain cases and controls randomly in the 
type III fashion}
\item{lab}{The labels of the points as 1 for cases and 0 for controls after the type III nonRL procedure is
applied to the data set, \code{dat}. Cases are denoted as red dots and controls as black circles in the plot.}
\item{init.cases}{The initial case in the data set, \code{dat}. Marked with a red cross in the plot of the points.}
\item{cont.cases}{The contagious cases in the data set, \code{dat}. Denoted as blue points in the plot of the points.}
\item{gen.points,ref.points}{Both are \code{NULL} for this function, as initial set of points, \code{dat}, are provided
for the non-RL procedure.}
\item{desc.pat}{Description of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The \code{vector} of two numbers, which are the number of cases and controls.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated and the reference points}
}
\description{
An object of class \code{"Patterns"}.

Given the set of \eqn{n} points, \code{dat}, in a region, this function assigns \eqn{n_1=}\code{round(n*prop,0)} of them as cases,
and the rest as controls with first selecting a point, \eqn{Z_i}, as a case and assigning the
label case to the remaining points with infection probabilities \eqn{prob=rho (1-d_{ij}/d_{\max})^{pow}} where \eqn{d_{ij}} is the
distance from \eqn{Z_j} to \eqn{Z_i} for \eqn{j \ne i}, \eqn{d_{\max}} is the maximum of  \eqn{d_{ij}}  values, \code{rho} is a scaling parameter for
the infection probabilities and \code{pow} is a parameter in the power adjusting the distance dependence.
The number of cases will be \eqn{n_1} on the average if the argument \code{poisson=TRUE}
(i.e., \eqn{n_1=}\code{rpois(1,round(n*prop,0))} ), otherwise \eqn{n_1=}\code{round(n*prop,0)}.
We stop when we first exceed \eqn{n_1} cases. \code{rho} has to be positive for \code{prob} to be a \code{vector} of probabilities,
and for a given \code{rho}, \code{pow} must be \eqn{> - \ln(rho)/\ln(1-d_{ij}/d_{\max})},
also, when \code{pow} is given, \code{rho} must be \eqn{< (1-d_{ij}/d_{\max})^{-pow}}.
If \code{rand.init=TRUE}, initial case is selected randomly among the data points,
otherwise first entry is chosen as the case (or case is recorded as the first entry) in the data set, \code{dat}. 

Algorithmically, first all dat points are treated as non-cases (i.e. controls or healthy subjects).
Then the function follows the following steps for labeling of the points: 

step 0: \eqn{n_1} is generated randomly from a Poisson distribution with \code{mean = round(n*prop,0)}, so that the 
average number of cases will be round(n*prop,0) if the argument \code{poisson=TRUE}, else \eqn{n_1=}\code{round(n*prop,0)}.

step 1: Initially, one point from dat is selected as a case.
The selection of initial case is determined based on the argument \code{rand.init} (with default=\code{TRUE})
where if \code{rand.init=TRUE} then the initial case is selected randomly from the data points, and if \code{rand.init=}
\code{FALSE}, the first entry in the data set, \code{dat}, is selected as the case.

step 2: Then it assigns the label case to the remaining points
with infection probabilities \eqn{prob=rho (1-d_{ij}/d_{\max})^{pow}}, see the description for the details
of the parameters in the \code{prob}.

step 3: The procedure ends when number of cases \eqn{n_c} exceeds \eqn{n_1}, and \eqn{n_c-n_1} of the cases (other than the
initial contagious case) are randomly selected and relabeled as controls, i.e. 0s,
so that the number of cases is exactly \eqn{n_1}.

In the output cases are labeled as 1 and controls as 0, and initial contagious case is marked with a red cross
in the plot of the pattern.
Note that the infection probabilities of the points is inversely proportional to their distances to the
initial case and increase with increasing \code{rho}. 
This function might take a long time for certain choices of the arguments. For example, if \code{pow} is taken to be
too large, the infection probabilities would be too small, and case assignment will take a rather long time. 

See \insertCite{ceyhan:SiM-seg-ind2014;textual}{nnspat} for more detail where type III non-RL pattern is the 
case 3 of non-RL pattern considered in Section 6 with \eqn{n_1} is
fixed as a parameter rather than being generated from a Poisson distribution and \eqn{k_{den}=1} and pow
is represented as \eqn{k_{pow}}.

Although the non-RL pattern is described for the case-control setting, it can be adapted for any two-class
setting when it is appropriate to treat one of the classes as cases or one of the classes behave like cases
and other class as controls.
}
\examples{
n<-40;  #try also n<-20; n<-100;
prop<- .5; #try also .25, .75
#data generation
dat<-cbind(runif(n,0,1),runif(n,0,1))

rho<-.8
pow<-2

Xdat<-rnonRLIII(dat,prop,rho,pow,poisson=FALSE) #labeled data, try also poisson=TRUE

Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#normal original data
n<-40;  #try also n<-20; n<-100;
dat<-cbind(rnorm(n,0,1),rnorm(n,0,1))

prop<- .5; #try also .25, .75
rho<-.8
pow<-2

Xdat<-rnonRLIII(dat,prop,rho,pow,poisson=FALSE) #labeled data, try also poisson=TRUE
Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rnonRLI}}, \code{\link{rnonRLII}}, \code{\link{rnonRLIV}}, and \code{\link{rnonRL}}
}
\author{
Elvan Ceyhan
}
