% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{var.seg.coeff}
\alias{var.seg.coeff}
\title{Variances of Segregation Coefficients in a Multi-class Case}
\usage{
var.seg.coeff(ct, covN)
}
\arguments{
\item{ct}{A nearest neighbor contingency table}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized entries of NNCT}
}
\value{
A \code{vector} of length \eqn{k(k+1)/2}, whose entries are the variances of segregation coefficients for the
entry \eqn{i,j} in the NNCT, where the order of the variances are as in the order of rows output of 
\code{\link{ind.seg.coeff}(k)}.
}
\description{
Returns the variances of segregation coefficients in a multi-class case based on the NNCT, \code{ct} 
in a \code{vector} of length \eqn{k(k+1)/2}, the order of the variances are as in the order of rows output of 
\code{\link{ind.seg.coeff}(k)}. These variances are valid under RL or conditional on \eqn{Q} and \eqn{R} under CSR.

See also (\insertCite{ceyhan:SiM-seg-ind2014;textual}{nnspat}).

The argument \code{covN} is the covariance matrix of \eqn{N_{ij}} (concatenated rowwise).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

var.seg.coeff(ct,covN)
varPseg.coeff(ct,covN)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

var.seg.coeff(ct,covN)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

var.seg.coeff(ct,covN)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{seg.coeff}}, \code{\link{cov.seg.coeff}}, \code{\link{var.nnsym}}
and \code{\link{var.nnct}} and
}
\author{
Elvan Ceyhan
}
