% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{matrix.sqrt}
\alias{matrix.sqrt}
\title{Square root of a matrix}
\usage{
matrix.sqrt(A)
}
\arguments{
\item{A}{A matrix, not necessarily square}
}
\value{
Returns the square root of \eqn{A}, if exists, otherwise gives an error message.
}
\description{
Computes the square root of the matrix \eqn{A}, where \eqn{A} does not have to be a square matrix, 
when the square root exists.
See https://people.orie.cornell.edu/davidr/SDAFE2/Rscripts/SDAFE2.R
}
\examples{
A<-matrix(sample(20:40,4),ncol=2)
matrix.sqrt(A)

A<-matrix(sample(20:40,16),ncol=4)
matrix.sqrt(A)
#sqrt of inverse of A, or sqrt inverse of A
matrix.sqrt(solve(A))

#non-square matrix
A<-matrix(sample(20:40,20),ncol=4)
matrix.sqrt(A)

}
\author{
Elvan Ceyhan
}
