% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{ipd.mat}
\alias{ipd.mat}
\title{Interpoint Distance Matrix}
\usage{
ipd.mat(x, y = NULL, ...)
}
\arguments{
\item{x}{A set of points in matrix or data frame form where points correspond to the rows.}

\item{y}{A set of points in matrix or data frame form where points correspond to the rows (default=\code{NULL}).}

\item{\dots}{Additional parameters to be passed on the \code{dist} function.}
}
\value{
A distance matrix whose i,j-th entry is the distance between row \eqn{i} of \code{x} and row \eqn{j} of \code{y} if \code{y} is provided,
otherwise i,j-th entry is the distance between rows \eqn{i} and \eqn{j} of \code{x}.
}
\description{
This function computes and returns the distance matrix computed by using the specified distance measure to
compute the distances between the rows of the set of points \code{x} and \code{y} using the 
\code{\link[stats]{dist}} function in the \code{stats} package of the standard R distribution.
If \code{y} is provided (default=\code{NULL}) it yields a matrix of distances between the rows of \code{x} and rows of \code{y},
otherwise, it provides a square matrix with i,j-th entry being the distance between row \eqn{i} and row \eqn{j} of \code{x}.
This function is different from the \code{\link[stats]{dist}} function in the \code{stats} package.
\code{dist} returns the distance matrix in a lower triangular form, and \code{ipd.mat} returns in a full matrix.
\dots are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
}
\examples{
#3D data points
n<-3
X<-matrix(runif(3*n),ncol=3)
mtd<-"euclidean" #try also "maximum", "manhattan", "canberra", "binary"
ipd.mat(X,method=mtd)
ipd.mat(X,method="minkowski",p=6)

n<-5
Y<-matrix(runif(3*n),ncol=3)
ipd.mat(X,Y,method=mtd)
ipd.mat(X[1,],Y,method=mtd)
ipd.mat(c(.1,.2,.3),Y,method=mtd)
ipd.mat(X[1,],Y[3,],method=mtd)

#1D data points
X<-as.matrix(runif(3)) # need to be entered as a matrix with one column 
#(i.e., a column vector), hence X<-runif(3) would not work
ipd.mat(X)

Y<-as.matrix(runif(5))
ipd.mat(X,Y)
ipd.mat(X[1,],Y)
ipd.mat(X[1,],Y[3,])

}
\seealso{
\code{\link[stats]{dist}}, \code{\link{ipd.mat.euc}}, \code{\link{dist.std.data}}
}
\author{
Elvan Ceyhan
}
