% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funsN_I_II}
\alias{funsN_I_II}
\alias{nnct.cr1}
\alias{nnct.cr2}
\title{Correction Matrices for the NNCT entries}
\usage{
nnct.cr1(ct)

nnct.cr2(ct)
}
\arguments{
\item{ct}{A nearest neighbor contingency table}
}
\value{
Both functions return a \eqn{k \times k} contingency table which is to be row-wise vectorized to obtain \eqn{N_I} and \eqn{N_{II}}
vectors which are used in the correction summands to obtain types I and II overall tests from Pielou's 
test of segregation.
See the description above for further detail.
}
\description{
Two functions: \code{nnct.cr1} and \code{nnct.cr1}.

Each function yields matrices which are used in obtaining the correction term to be added to 
the usual Chi-Square test of contingency tables (i.e. Pielou's test) applied
on NNCTs to obtain types I and II overall tests.
The output contingency tables are to be row-wise vectorized to obtain \eqn{N_I} and \eqn{N_{II}} vectors. 
See Sections 3.1 and 3.2 in 
(\insertCite{ceyhan:SJScorrected2010;textual}{nnspat})
or
Sections 3.5.1 and 3.5.2 in 
(\insertCite{ECarXivCorrected:2008;textual}{nnspat}) for more details.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

#correction type 1
ct1<-nnct.cr1(ct)

#correction type 2
ct2<-nnct.cr2(ct)

ct
ct1
ct2

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{correct.cf1}} and \code{\link{correct.cf2}}
}
\author{
Elvan Ceyhan
}
