% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{Tcomb}
\alias{Tcomb}
\title{Cuzick & Edwards Tcomb Test Statistic}
\usage{
Tcomb(
  dat,
  cc.lab,
  klist,
  case.lab = NULL,
  nonzero.mat = TRUE,
  asy.cov = FALSE,
  ...
)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point.}

\item{cc.lab}{Case-control labels, 1 for case, 0 for control}

\item{klist}{\code{list} of integers specifying the indices of the \eqn{T_k} values used in obtaining the \eqn{T_{comb}}.}

\item{case.lab}{The label used for cases in the \code{cc.lab} (if \code{cc.lab} is not provided then the labels are converted
such that cases are 1 and controls are 0), default is \code{NULL}.}

\item{nonzero.mat}{A logical argument (default is \code{TRUE}) to determine whether the \eqn{A} matrix or the matrix of
nonzero locations of the \eqn{A} matrix will be used in the computation of \eqn{N_s} and \eqn{N_t}.
If \code{TRUE} the nonzero location matrix is used, otherwise the \eqn{A} matrix itself is used.}

\item{asy.cov}{A logical argument (default is \code{FALSE}) to determine whether asymptotic or exact (i.e., finite
sample) covariances between \eqn{T_k} and \eqn{T_l} values are to be used to obtain the entries of the covariance matrix.
If \code{TRUE} the asymptotic covariance values are used, otherwise exact covariance values are used.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
Returns the value of the \eqn{T_{comb}} test statistic
}
\description{
This function computes the value of Cuzick & Edwards \eqn{T_{comb}} test statistic in disease clustering, where \eqn{T_{comb}}
is a linear combination of some \eqn{T_k} tests.

The argument \code{cc.lab} is case-control label, 1 for case, 0 for control, if the argument \code{case.lab} is \code{NULL}, 
then \code{cc.lab} should be provided in this fashion, if \code{case.lab} is provided, the labels are converted to 0's 
and 1's accordingly. 

The argument \code{klist} is the \code{vector} of integers specifying the indices of the \eqn{T_k} values used
in obtaining the \eqn{T_{comb}}.

The logical argument \code{nonzero.mat} (default=\code{TRUE}) is for using the \eqn{A} matrix if \code{FALSE} or just the matrix of nonzero
locations in the \eqn{A} matrix (if \code{TRUE}) in the computations.

The logical argument \code{asy.cov} (default=\code{FALSE}) is for using the asymptotic covariance or the exact (i.e. finite
sample) covariance for the vector of \eqn{T_k} values used in \code{Tcomb} in the standardization of \eqn{T_{comb}}.
If \code{asy.cov=TRUE}, the asymptotic covariance is used, otherwise the exact covariance is used. 
  
See page 87 of (\insertCite{cuzick:1990;textual}{nnspat}) for more details.
}
\examples{
n<-20  #or try sample(1:20,1) #try also n<-50, 100
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)  #or try cls<-rep(0:1,c(10,10))
n1<-sum(cls==1)

kl<-sample(1:5,3) #try also sample(1:5,2)
kl
Tcomb(Y,cls,kl)
Tcomb(Y,cls,kl,method="max")
Tcomb(Y,cls+1,kl,case.lab=2)
Tcomb(Y,cls,kl,nonzero.mat = FALSE)
Tcomb(Y,cls,kl,asy.cov = TRUE)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
Tcomb(Y,fcls,kl,case.lab="a")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTk}}, \code{\link{EV.Tcomb}}, and \code{\link{ZTcomb}}
}
\author{
Elvan Ceyhan
}
