% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_nls.R
\name{predict_nls}
\alias{predict_nls}
\alias{predict2_gam}
\title{Average predictions from several (non)linear models based on IC weights}
\usage{
predict_nls(
  ...,
  criteria = c("AIC", "AICc", "BIC"),
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  nsim = 1000,
  resid.type = c("none", "resample", "normal", "wild"),
  newdata = NULL,
  weights
)

predict2_gam(
  ...,
  criteria = c("AIC", "AICc", "BIC"),
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  nsim = 1000,
  resid.type = c("none", "resample", "normal", "wild"),
  newdata = NULL,
  weights
)
}
\arguments{
\item{...}{\sQuote{nls} or \sQuote{lm} objects (\sQuote{glm} and \sQuote{gam} objects inherit \sQuote{lm}).}

\item{criteria}{either \sQuote{AIC}, \sQuote{AICc} or \sQuote{BIC}.}

\item{interval}{either \sQuote{none}, \sQuote{confidence} or \sQuote{prediction}.}

\item{level}{probability level for the interval (default 0.95)}

\item{nsim}{number of simulations to perform for intervals. Default 1000.}

\item{resid.type}{either \sQuote{none}, \dQuote{resample}, \dQuote{normal} or \dQuote{wild}.}

\item{newdata}{new data frame for predictions}

\item{weights}{vector of weights of the same length as the number of models. It should sum up to one and 
it will override the information-criteria based weights. The weights should match the order of the models.}
}
\value{
numeric vector of the same length as the fitted object when interval is equal to \sQuote{none}. Otherwise,
a data.frame with columns named (for a 0.95 level) \sQuote{Estimate}, \sQuote{Est.Error}, \sQuote{Q2.5} and \sQuote{Q97.5}
}
\description{
Computes weights based on AIC, AICc, or BIC and it generates weighted predictions by
the relative value of the IC values

predict function for objects of class \code{\link[mgcv]{gam}}
}
\note{
all the objects should be fitted to the same data. Weights are
based on the chosen IC value (exp(-0.5 * delta IC)). 
For models of class \code{\link[mgcv]{gam}} there is very limited support.
}
\examples{
\donttest{
## Example
require(ggplot2)
require(mgcv)
data(barley, package = "nlraa")

fm.L <- lm(yield ~ NF, data = barley)
fm.Q <- lm(yield ~ NF + I(NF^2), data = barley)
fm.A <- nls(yield ~ SSasymp(NF, Asym, R0, lrc), data = barley)
fm.LP <- nls(yield ~ SSlinp(NF, a, b, xs), data = barley)
fm.QP <- nls(yield ~ SSquadp3(NF, a, b, c), data = barley)
fm.BL <- nls(yield ~ SSblin(NF, a, b, xs, c), data = barley)
fm.G <- gam(yield ~ s(NF, k = 6), data = barley)

## Print the table with weights
IC_tab(fm.L, fm.Q, fm.A, fm.LP, fm.QP, fm.BL, fm.G)

## Each model prediction is weighted according to their AIC values
prd <- predict_nls(fm.L, fm.Q, fm.A, fm.LP, fm.QP, fm.BL, fm.G)

ggplot(data = barley, aes(x = NF, y = yield)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fm.L), color = "Linear")) +
  geom_line(aes(y = fitted(fm.Q), color = "Quadratic")) +
  geom_line(aes(y = fitted(fm.A), color = "Asymptotic")) +  
  geom_line(aes(y = fitted(fm.LP), color = "Linear-plateau")) + 
  geom_line(aes(y = fitted(fm.QP), color = "Quadratic-plateau")) + 
  geom_line(aes(y = fitted(fm.BL), color = "Bi-linear")) + 
  geom_line(aes(y = fitted(fm.G), color = "GAM")) + 
  geom_line(aes(y = prd, color = "Avg. Model"), size = 1.2)
}
}
\seealso{
\code{\link[stats]{predict.lm}}, \code{\link[stats]{predict.nls}}, \code{\link[mgcv]{predict.gam}}, \code{\link{simulate_nls}}, \code{\link{simulate_gam}}
}
