% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_lm.R
\name{boot_lm}
\alias{boot_lm}
\title{Bootstrapping for linear models}
\usage{
boot_lm(
  object,
  f = NULL,
  R = 999,
  psim = 2,
  resid.type = c("resample", "normal", "wild"),
  data = NULL,
  ...
)
}
\arguments{
\item{object}{object of class \code{\link[stats]{lm}}}

\item{f}{function to be applied (and bootstrapped), default coef}

\item{R}{number of bootstrap samples, default 999}

\item{psim}{simulation level for \code{\link{simulate_lm}}}

\item{resid.type}{either \dQuote{resample}, \dQuote{normal} or \dQuote{wild}.}

\item{data}{optional data argument (useful/needed when data are not in an available environment).}

\item{...}{additional arguments to be passed to function \code{\link[boot]{boot}}}
}
\description{
Bootstraping for linear models
}
\details{
The residuals can either be generated by resampling with replacement (default),
from a normal distribution (parameteric) or by changing their signs (wild). This last
one is called \dQuote{wild bootstrap}.
}
\note{
at the moment, when the argument data is used, it is not possible to check that it matches the 
original data used to fit the model. It will also override the fetching of data.
}
\examples{
\donttest{
require(car)
data(barley, package = "nlraa")
## Fit a linear model (quadratic)
fit.lm <- lm(yield ~ NF + I(NF^2), data = barley)

## Bootstrap coefficients by default
fit.lm.bt <- boot_lm(fit.lm)
## Compute confidence intervals
confint(fit.lm.bt, type = "perc")
## Visualize
hist(fit.lm.bt, 1, ci = "perc", main = "Intercept")
hist(fit.lm.bt, 2, ci = "perc", main = "NF term")
hist(fit.lm.bt, 3, ci = "perc", main = "I(NF^2) term")
}

}
