% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSbgf4.R
\name{SSbgf4}
\alias{SSbgf4}
\alias{bgf4}
\title{self start for Beta growth function with four parameters}
\usage{
bgf4(time, w.max, t.e, t.m, t.b)

SSbgf4(time, w.max, t.e, t.m, t.b)
}
\arguments{
\item{time}{input vector (x) which is normally \sQuote{time}.}

\item{w.max}{value of weight or mass at its peak.}

\item{t.e}{time at which the weight or mass reaches its peak.}

\item{t.m}{time at which half of the maximum weight or mass has been reached.}

\item{t.b}{time at which growth starts.}
}
\value{
a numeric vector of the same length as x (time) containing parameter estimates for equation specified

bgf4: vector of the same length as x (time) using the beta growth function with four parameters
}
\description{
Self starter for Beta Growth function with parameters w.max, t.e, t.m and t.b
}
\details{
For details see the publication by Yin et al. (2003) \dQuote{A Flexible Sigmoid Function of Determinate Growth}.
This is a difficult function to fit because the linear constrains are not explicitly introduced 
in the optimization process. See function \code{\link{SSbgrp}} for a reparameterized version.

This is equation 11 (pg. 368) in the publication by Yin, but with correction (https://doi.org/10.1093/aob/mcg091) and with \sQuote{w.b} equal to zero.
}
\examples{
\donttest{
data(sm)
## Let's just pick one crop
sm2 <- subset(sm, Crop == "M")
fit <- nls(Yield ~ SSbgf4(DOY, w.max, t.e, t.m, t.b), data = sm2)
plot(Yield ~ DOY, data = sm2)
lines(sm2$DOY,fitted(fit))
## For this particular problem it could be better to 'fix' t.b and w.b
fit0 <- nls(Yield ~ bgf2(DOY, w.max, w.b = 0, t.e, t.m, t.b = 141), 
           data = sm2, start = list(w.max = 16, t.e= 240, t.m = 200))
}
x <- seq(0, 17, by = 0.25)
y <- bgf4(x, 20, 15, 10, 2)
plot(x, y)
}
