% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSricker.R
\name{SSricker}
\alias{SSricker}
\alias{ricker}
\title{self start for Ricker Function}
\usage{
ricker(time, a, b)

SSricker(time, a, b)
}
\arguments{
\item{time}{input vector (x) which is normally \sQuote{time}, the smallest value should be close to zero.}

\item{a}{which is related to the initial growth slope}

\item{b}{which is related to the slowing down or decline}
}
\value{
a numeric vector of the same length as x (time) containing parameter estimates for equation specified

ricker: vector of the same length as x (time) using the ricker function
}
\description{
Self starter for Ricker function with parameters a and b
}
\details{
This function is described in Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506) and originally in Ricker, W. E. (1954) Stock and Recruitment Journal of the Fisheries Research Board of Canada, 11(5): 559–623. (doi:10.1139/f54-039).
The equation is: \eqn{a * time * exp(-b * time)}.
}
\examples{
\donttest{
require(ggplot2)
set.seed(123)
x <- 1:30
y <- 30 * x * exp(-0.3 * x) + rnorm(30, 0, 0.25)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSricker(x, a, b), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
