% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cobyla.R
\name{bobyqa}
\alias{bobyqa}
\title{Bound Optimization by Quadratic Approximation}
\usage{
bobyqa(
  x0,
  fn,
  lower = NULL,
  upper = NULL,
  nl.info = FALSE,
  control = list(),
  ...
)
}
\arguments{
\item{x0}{starting point for searching the optimum.}

\item{fn}{objective function that is to be minimized.}

\item{lower, upper}{lower and upper bound constraints.}

\item{nl.info}{logical; shall the original \acronym{NLopt} info be shown.}

\item{control}{list of options, see \code{nl.opts} for help.}

\item{...}{additional arguments passed to the function.}
}
\value{
List with components:
\item{par}{the optimal solution found so far.}
\item{value}{the function value corresponding to \code{par}.}
\item{iter}{number of (outer) iterations, see \code{maxeval}.}
\item{convergence}{integer code indicating successful completion (> 0)
or a possible error number (< 0).}
\item{message}{character string produced by \acronym{NLopt} and giving
additional information.}
}
\description{
\acronym{BOBYQA} performs derivative-free bound-constrained optimization
using an iteratively constructed quadratic approximation for the objective
function.
}
\details{
This is an algorithm derived from the \acronym{BOBYQA} Fortran subroutine of
Powell, converted to C and modified for the \acronym{NLopt} stopping
criteria.
}
\note{
Because \acronym{BOBYQA} constructs a quadratic approximation of the
objective, it may perform poorly for objective functions that are not
twice-differentiable.
}
\examples{

## Rosenbrock Banana function

rbf <- function(x) {(1 - x[1]) ^ 2 + 100 * (x[2] - x[1] ^ 2) ^ 2}

## The function as written above has a minimum of 0 at (1, 1)

S <- bobyqa(c(0, 0), rbf)


S

## Rosenbrock Banana function with both parameters constrained to [0, 0.5]

S <- bobyqa(c(0, 0), rbf, lower = c(0, 0), upper = c(0.5, 0.5))

S

}
\references{
M. J. D. Powell. ``The BOBYQA algorithm for bound constrained
optimization without derivatives,'' Department of Applied Mathematics and
Theoretical Physics, Cambridge England, technical reportNA2009/06 (2009).
}
\seealso{
\code{\link{cobyla}}, \code{\link{newuoa}}
}
