% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesiancovsel.R
\name{horseshoeSummardf}
\alias{horseshoeSummardf}
\title{Create Horseshoe summary posterior estimates}
\usage{
horseshoeSummardf(fit, covarsVec, ...)
}
\arguments{
\item{fit}{compiled rxode2 nlmir2 model fit}

\item{covarsVec}{character vector of covariates that need to be added}

\item{...}{other parameters passed to brm(): warmup = 1000, iter = 2000, chains = 4, cores = 4,
control = list(adapt_delta = 0.99, max_treedepth = 15)}
}
\value{
Horse shoe Summary data frame of all covariates
}
\description{
Create Horseshoe summary posterior estimates
}
\examples{

\donttest{

one.cmt <- function() {
  ini({
    ## You may label each parameter with a comment
    tka <- 0.45 # Log Ka
    tcl <- log(c(0, 2.7, 100)) # Log Cl
    ## This works with interactive models
    ## You may also label the preceding line with label("label text")
    tv <- 3.45; label("log V")
    ## the label("Label name") works with all models
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    linCmt() ~ add(add.sd)
  })
}

d <- nlmixr2data::theo_sd
fit <- nlmixr2(one.cmt, d, "focei")
covarsVec <- c("WT")

# Horseshoe summary posterior estimates:

#hsDf <- horseshoeSummardf(fit,covarsVec,cores=2)
#brms sometimes may throw a Error in sink(type = “output”)
#Issue Should be fixed by uninstalling and re-installing rstan

}
}
\author{
Vishal Sarsani, Christian Bartels
}
