% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augPred.R
\name{nlmixr2AugPredSolve}
\alias{nlmixr2AugPredSolve}
\alias{augPred.nlmixr2FitData}
\title{Augmented Prediction for nlmixr2 fit}
\usage{
nlmixr2AugPredSolve(
  fit,
  covsInterpolation = c("locf", "nocb", "linear", "midpoint"),
  minimum = NULL,
  maximum = NULL,
  length.out = 51L,
  ...
)

\method{augPred}{nlmixr2FitData}(
  object,
  primary = NULL,
  minimum = NULL,
  maximum = NULL,
  length.out = 51,
  ...
)
}
\arguments{
\item{fit}{Nlmixr2 fit object}

\item{covsInterpolation}{specifies the interpolation method for
time-varying covariates. When solving ODEs it often samples
times outside the sampling time specified in \code{events}.
When this happens, the time varying covariates are
interpolated.  Currently this can be:
\itemize{
\item \code{"linear"} interpolation, which interpolates the covariate
by solving the line between the observed covariates and extrapolating the new
covariate value.
\item \code{"constant"} -- Last observation carried forward (the default).
\item \code{"NOCB"} -- Next Observation Carried Backward.  This is the same method
that NONMEM uses.
\item \code{"midpoint"} Last observation carried forward to midpoint; Next observation
carried backward to midpoint.
}}

\item{minimum}{an optional lower limit for the primary
   covariate. Defaults to \code{min(primary)}.}

\item{maximum}{an optional upper limit for the primary
   covariate. Defaults to \code{max(primary)}.}

\item{length.out}{an optional integer with the number of primary
   covariate values at which to evaluate the predictions.  Defaults to
   51.}

\item{...}{some methods for the generic may require additional
   arguments.}

\item{object}{a fitted model object from which predictions can be
   extracted, using a \code{predict} method.}

\item{primary}{an optional one-sided formula specifying the primary
   covariate to be used to generate the augmented predictions. By
   default, if a  covariate can be extracted from the data used to generate
   \code{object} (using \code{getCovariate}), it will be used as
   \code{primary}.}
}
\value{
Stacked data.frame with observations, individual/population predictions.
}
\description{
Augmented Prediction for nlmixr2 fit
}
\author{
Matthew L. Fidler
}
