% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asVPC.R
\name{asVPC}
\alias{asVPC}
\title{the average shifted visual predictive checks (asVPC)}
\usage{
asVPC(orig_data,
      sim_data,
      type="CI",                
      weight_method="bin",                  
      N_xbin=NULL,
      N_hist = NULL,
      probs=c(0.1,0.5,0.9),
      conf.level=0.95,
      X_name="TIME",
      Y_name="DV",
      MissingDV = NULL,
      DV_point = TRUE,                
      CIvpc_type="line",
      bin_grid=TRUE,                   
      plot_caption = TRUE,
      plot_flag=TRUE,
      linesize=0.7,
      pointsize=0.7,
      captionsize=10,
      Kmethod="cluster",                
      maxK=NULL,
      beta=0.2,
      lambda=0.3,
      R=4,
      C1=2.5,
      C2=7.8,...)
}
\arguments{
\item{orig_data}{A data frame of original data with X and Y variable.}

\item{sim_data}{A matrix of simulated data with only Y values collected.}

\item{type}{Type of VPC graph; "CI", "percentile", or "scatter".}

\item{weight_method}{The way to put weight when the average shifted values are calculated. "bin" or "distance".}

\item{N_xbin}{Number of bins in X variable. If NULL, optimal number of bins are automatically calcuated using optK function.}

\item{N_hist}{The number of shifted histograms.}

\item{probs}{A numeric vector of probabilities.}

\item{conf.level}{Confidence level of the interval.}

\item{X_name}{Name of X variable in orig_data (usually "TIME" in pharmacokinetic data).}

\item{Y_name}{Name of Y variable in orig_data (usually "DV" in pharmacokinetic data).}

\item{MissingDV}{Name of missing indicator variable in orig_data, which have value 1 if missing, value 0 otherwise. (usually "MDV" in pharmacokinetic data).}

\item{DV_point}{Draw point (X, Y) in the plot if TRUE; omit if FALSE.}

\item{CIvpc_type}{Type of CI area in VPC graph; "line" or "segment".}

\item{bin_grid}{Draw grid lines for binning in X variable if TRUE; omit if FALSE.}

\item{plot_caption}{Put caption with additional information if TRUE; omit if FALSE.}

\item{plot_flag}{Draw plot if TRUE; generate data for drawing plot if FALSE.}

\item{linesize}{Size of line in the plot.}

\item{pointsize}{Size of point in the plot.}

\item{captionsize}{Size of caption.}

\item{Kmethod}{The way to calculate the penalty in automatic binning."cluster" or "kernel".}

\item{maxK}{The maximum number of bins.}

\item{beta}{Additional parameter for automatic binning, used in optK function.}

\item{lambda}{Additional parameter for automatic binning, used in optK function.}

\item{R}{Additional parameter for automatic binning, used in optK function.}

\item{C1}{Additional parameter for automatic binning, used in optK function.}

\item{C2}{Additional parameter for automatic binning, used in optK function.}

\item{...}{Arguments to be passed to methods.}
}
\value{
asVPC plot or the values to draw asVPC plot.
}
\description{
This function calculates percentiles of original data  and simulated data 
using bin-related weights, and draw the VPC type plot
}
\examples{
\donttest{
data(origdata)
data(simdata)
asVPC(origdata,simdata,type="CI",N_hist=3,weight_method="distance")
asVPC(origdata,simdata,type="CI",N_hist=3,weight_method="bin")
}

}
