% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill-na.R
\name{fill_na.nlist}
\alias{fill_na.nlist}
\title{Fill Missing Values}
\usage{
\method{fill_na}{nlist}(x, value = 0L, ...)
}
\arguments{
\item{x}{An object.}

\item{value}{A scalar of the value to replace values with.}

\item{...}{Other arguments passed to methods.}
}
\value{
The modified object.
}
\description{
Fills all of an object's missing values
while preserving the object's dimensionality and class.
}
\details{
It should only be defined for objects with values of consistent class ie
not standard data.frames.
}
\section{Methods (by class)}{

\itemize{
\item \code{logical}: Fill Missing Values for logical Objects

\item \code{integer}: Fill Missing Values for integer Objects

\item \code{numeric}: Fill Missing Values for numeric Objects

\item \code{character}: Fill Missing Values for character Objects
}
}

\examples{
fill_na(nlist(x = c(2, NA), y = matrix(c(1:3, NA), nrow = 2)))
fill_na(nlists(nlist(x = c(2, NA)), nlist(x = c(NA_real_, NA))))
}
\seealso{
Other fill: 
\code{\link[extras]{fill_all}()}
}
