% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericise.R
\name{numericise}
\alias{numericise}
\alias{numericize}
\alias{numericise.default}
\alias{numericise.logical}
\alias{numericise.integer}
\alias{numericise.double}
\alias{numericise.factor}
\alias{numericise.Date}
\alias{numericise.POSIXct}
\alias{numericise.hms}
\alias{numericise.matrix}
\alias{numericise.array}
\alias{numericise.list}
\alias{numericise.data.frame}
\title{Numericise (or Numericize)}
\usage{
numericise(x, ...)

numericize(x, ...)

\method{numericise}{default}(x, ...)

\method{numericise}{logical}(x, ...)

\method{numericise}{integer}(x, ...)

\method{numericise}{double}(x, ...)

\method{numericise}{factor}(x, ...)

\method{numericise}{Date}(x, ...)

\method{numericise}{POSIXct}(x, ...)

\method{numericise}{hms}(x, ...)

\method{numericise}{matrix}(x, ...)

\method{numericise}{array}(x, ...)

\method{numericise}{list}(x, ...)

\method{numericise}{data.frame}(x, ...)
}
\arguments{
\item{x}{An R object.}

\item{...}{Unused}
}
\value{
The modified object.
}
\description{
Attempts to coerce a non-numeric R object to \code{\link[=natomic_object]{natomic_object()}} or
list of \code{{natomic_object}}.
If possible the dimensionality is preserved.
}
\details{
Date, POSIXct and hms objects are floored first.

\code{numericize()} is an alias for numericise.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Numericise default object

\item \code{logical}: Numericise logical vector

\item \code{integer}: Numericise integer vector

\item \code{double}: Numericise double vector

\item \code{factor}: Numericise factor

\item \code{Date}: Numericise Date

\item \code{POSIXct}: Numericise POSIXct

\item \code{hms}: Numericise hms

\item \code{matrix}: Numericise matrix

\item \code{array}: Numericise array

\item \code{list}: Numericise list

\item \code{data.frame}: Numericise data.frame
}}

\examples{
numericize(TRUE)
numericize("1.9")
numericize(factor(c("beta", "alpha")))
numericize(matrix(c(TRUE, FALSE, NA, TRUE), 2))
numericize(as.Date("1970-02-03"))
numericize(as.POSIXct("1970-02-03", tz = "GMT"))
}
