% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pyramid.plot.R
\name{pyramid.plot}
\alias{pyramid.plot}
\title{Pyramid plot function for creating population pyramids.}
\usage{
pyramid.plot(
  x,
  g,
  main = paste("Pyramid plot of", deparse(substitute(x)), "by", deparse(substitute(g))),
  xlab = paste(deparse(substitute(g)), "(", levels(as.factor(g))[1], "/",
    levels(as.factor(g))[2], ")"),
  ylab = deparse(substitute(x)),
  col = "white",
  ...
)
}
\arguments{
\item{x}{Vector of ages (usually grouped)}

\item{g}{Vector of groups (usually sex)}

\item{main}{Plot title}

\item{xlab}{\code{x-axis} label}

\item{ylab}{\code{y-axis} label}

\item{col}{Colours for bars. Either a single colour (default is
\code{col = "white"}) for all bars, two colours (e.g. \code{col = c("lightblue", "pink")})
for left hand side bars and right hand side bars respectively, or many
colours allocated on a \code{checkerboard} basis to each bar}

\item{...}{Other graphical parameters}
}
\value{
A table of \code{x} by \code{g} (invisible)
}
\description{
Pyramid plot function for creating population pyramids.
}
\examples{
# Use pyramid.plot() on anthropometric data from a SMART survey in
# Kabul, Afghanistan (dp.ex02)
svy <- dp.ex02
pyramid.plot(svy$age, svy$sex)

}
