% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ageRatioTest.R
\name{ageRatioTest}
\alias{ageRatioTest}
\title{Age ratio test}
\usage{
ageRatioTest(x, ratio = 0.85)
}
\arguments{
\item{x}{A vector of ages. Should either be in whole months (integer) or in
calculated decimal months (numeric).}

\item{ratio}{Expected age ratio. Default is 0.85.}
}
\value{
A lit of class \code{"ageRatioTest"} with:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \emph{expectedR} \tab Expected sex ratio \cr
   \emph{expectedP} \tab Expected proportion aged 6:29 months \cr
   \emph{observedR} \tab Observed sex ratio \cr
   \emph{observedP} \tab Observed proportion aged 6:29 months \cr
   \emph{X2} \tab Chi-squared test statistic \cr
   \emph{df} \tab Degrees of freedom for Chi-squared test \cr
   \emph{p} \tab \code{p-value} for Chi-squared test \cr
}
}
\description{
Age ratio test is an age-related test of survey and data quality. In this
test, the ratio of the number of children aged from 6 to 29 months to the
number of children aged from 30 to 59 months is calculated. This ratio is
then compared to an expected ratio (usually set at 0.85). The difference
of the observed ratio to the expected ratio is then compared statistically
using Chi-squared test.
}
\examples{
# Age-ratio test on survey dataset from Kabul, Afghanistan (`dp.ex02`)
# with an age ratio of 0.85
svy <- dp.ex02
ageRatioTest(svy$age, ratio = 0.85)

# The age ratio test applied to data for each sex separately
by(svy$age, svy$sex, ageRatioTest, ratio = 0.85)

}
