% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fullTable.R
\name{fullTable}
\alias{fullTable}
\title{Fill out a one-dimensional table to include a specified range of values}
\usage{
fullTable(x, values = min(x, na.rm = TRUE):max(x, na.rm = TRUE))
}
\arguments{
\item{x}{A vector to tabulate}

\item{values}{A vector of values to be included in a table. Default is:
\code{min(x, na.rm = TRUE):max(x, na.rm = TRUE)}}
}
\value{
A table object including zero cells
}
\description{
Fill out a one-dimensional table to include a specified range of values
}
\examples{
# Generate some artificial data and then apply `fullTable()`
set.seed(0)
finalDigits <- sample(x = 0:9, size = 1000, replace = TRUE)
fullTable(finalDigits)

}
