% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nimbleFunction_Rexecution.R
\name{getParam}
\alias{getParam}
\title{Get value of a parameter of a stochastic node in a model}
\usage{
getParam(model, node, param, nodeFunctionIndex)
}
\arguments{
\item{model}{A NIMBLE model object}

\item{node}{The name of a stochastic node in the model}

\item{param}{The name of a parameter for the node}

\item{nodeFunctionIndex}{For internal NIMBLE use only}
}
\description{
Get the value of a parameter for any single stochastic node in a model.
}
\details{
Standard usage is as a method of a model, in the form \code{model$getParam(node, param)}, but the usage as a simple function with the model as the first argument as above is also allowed.

For example, suppose node 'x[1:5]' follows a multivariate
normal distribution (dmnorm) in a model declared by BUGS code.
model$getParam('x[1:5]', 'mean') would return the current value of
the mean parameter (which may be determined from other nodes).  The
parameter requested does not have to be part of the
parameterization used to declare the node.  Rather, it can be any
parameter known to the distribution.  For example, one can request
the scale or rate parameter of a gamma distribution, regardless of
which one was used to declare the node.
}
