% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmph3UnEb/file63ef4546bacc
\name{nimInteger}
\alias{integer}
\alias{nimInteger}
\title{Creates an integer vector for use in NIMBLE DSL functions}
\usage{
nimInteger(length = 0, value = 0, init = TRUE)
}
\arguments{
\item{length}{the length of the vector (default = 0)}

\item{value}{the initial value for each element of the vector (default = 0L).  Only used if \code{init} is \code{TRUE}.}

\item{init}{logical, whether to initialize elements of the vector (default = TRUE).}
}
\description{
In a \code{nimbleFunction}, \code{integer} is identical to \code{nimInteger}
}
\details{
See the User Manual for usage examples.

When used in a \code{nimbleFunction} (in \code{run} or other member function), \code{integer} is a synonym for \code{nimInteger}.  When used with only the \code{length} argument, this behaves similarly to R's \code{integer} function.  NIMBLE provides additional arguments to control the initialization value and whether or not initialization will occur.  Using \code{init=FALSE} when initialization is not necessary can make compiled nimbleFunctions a bit faster.
}
\author{
Daniel Turek
}
\seealso{
\code{\link{numeric}} \code{\link{matrix}} \code{\link{array}}
}

