% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions_implementations.R
\name{Wishart}
\alias{Wishart}
\alias{dwish_chol}
\alias{rwish_chol}
\alias{wishart}
\title{The Wishart Distribution}
\usage{
dwish_chol(x, cholesky, df, scale_param = TRUE, log = FALSE)

rwish_chol(n = 1, cholesky, df, scale_param = TRUE)
}
\arguments{
\item{x}{vector of values.}

\item{cholesky}{upper-triangular Cholesky factor of either the scale matrix (when \code{scale_param} is TRUE) or rate matrix (otherwise).}

\item{df}{degrees of freedom.}

\item{scale_param}{logical; if TRUE the Cholesky factor is that of the scale matrix; otherwise, of the rate matrix.}

\item{log}{logical; if TRUE, probability density is returned on the log scale.}

\item{n}{number of observations (only \code{n=1} is handled currently).}
}
\value{
\code{dwish_chol} gives the density and \code{rwish_chol} generates random deviates.
}
\description{
Density and random generation for the Wishart distribution, using the Cholesky factor of either the scale matrix or the rate matrix.
}
\details{
See Gelman et al., Appendix A or the BUGS manual for mathematical details. The rate matrix as used here is defined as the inverse of the scale matrix, \eqn{S^{-1}}, given in Gelman et al.
}
\examples{
df <- 40
ch <- chol(matrix(c(1, .7, .7, 1), 2))
x <- rwish_chol(1, ch, df = df)
dwish_chol(x, ch, df = df)
}
\author{
Christopher Paciorek
}
\references{
Gelman, A., Carlin, J.B., Stern, H.S., and Rubin, D.B. (2004) \emph{Bayesian Data Analysis}, 2nd ed. Chapman and Hall/CRC.
}
\seealso{
\link{Distributions} for other standard distributions
}

