% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nimbleFunction_Rexecution.R
\name{nimOptim}
\alias{nimOptim}
\title{EXPERIMENTAL Nimble wrapper around R's builtin \code{\link{optim}}.}
\usage{
nimOptim(par, fn, gr = "NULL", ..., method = "Nelder-Mead", lower = -Inf,
  upper = Inf, control = nimOptimDefaultControl(), hessian = FALSE)
}
\arguments{
\item{par}{Initial values for the parameters to be optimized over.}

\item{fn}{A function to be minimized (or maximized), with first argument the
vector of parameters over which minimization is to take place. It
should return a scalar result.}

\item{gr}{A function to return the gradient for the "BFGS", "CG" and "L-BFGS-B" methods.
For the "SANN" method it specifies a function to generate a new candidate point.
If it is the string "NULL" a default Gaussian Markov kernel is used.}

\item{...}{IGNORED}

\item{method}{The method to be used. See \code{Details} section of \code{\link{optim}}. One of:
"Nelder-Mead", "BFGS", "CG", "L-BFGS-B", "SANN", "Brent"}

\item{lower}{Vector or scalar of lower bounds for parameters.}

\item{upper}{Vector or scalar of upper bounds for parameters.}

\item{control}{A list of control parameters. See \code{Details} section of \code{\link{optim}}.}

\item{hessian}{Logical. Should a Hessian matrix be returned?}
}
\value{
\code{\link{optimResultNimbleList}}
}
\description{
EXPERIMENTAL Nimble wrapper around R's builtin \code{\link{optim}}.
}
\seealso{
\code{\link{optim}}
}

