% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmp9wH6ZH/file2ef72b7bc8de
\name{buildBootstrapFilter}
\alias{buildBootstrapFilter}
\title{Create a bootstrap particle filter algorithm to estimate log-likelihood.}
\usage{
buildBootstrapFilter(model, nodes, control = list())
}
\arguments{
\item{model}{A nimble model object, typically representing a state
space model or a hidden Markov model}

\item{nodes}{A character vector specifying the latent model nodes
over which the particle filter will stochastically integrate over to
estimate the log-likelihood function}

\item{control}{A list specifying different control options for the particle filter.  Options are described in the details section below.}
}
\description{
Create a bootstrap particle filter algorithm for a given NIMBLE state space model.
}
\details{
Each of the \code{control()} list options are described in detail here:
\describe{
 \item{thresh}{ A number between 0 and 1 specifying when to resample: the resampling step will occur when the
  effective sample size is less than \code{thresh} times the number of particles.  Defaults to 0.8.}
 \item{saveAll}{Indicates whether to save state samples for all time points (TRUE), or only for the most recent time point (FALSE)}
 \item{smoothing}{Decides whether to save smoothed estimates of latent states, i.e., samples from f(x[1:t]|y[1:t]) if \code{smoothing = TRUE}, or instead to save filtered samples from f(x[t]|y[1:t]) if \code{smoothing = FALSE}.  \code{smoothing = TRUE} only works if \code{saveAll = TRUE}.}
 \item{timeIndex}{An integer used to manually specify which dimension of the latent state variable indexes time.
 Only needs to be set if the number of time points is less than or equal to the size of the latent state at each time point.}
}

 The bootstrap filter starts by generating a sample of estimates from the
 prior distribution of the latent states of a state space model.  At each time point, these particles are propagated forward
 by the model's transition equation.  Each particle is then given a weight
 proportional to the value of the observation equation given that particle.
 The weights are used to draw an equally-weighted sample of the particles at this time point.
 The algorithm then proceeds
 to the next time point.  Neither the transition nor the observation equations are required to
 be normal for the bootstrap filter to work.

 The resulting specialized particle filter algorthm will accept a
 single integer argument (\code{m}, default 10,000), which specifies the number
 of random \'particles\' to use for estimating the log-likelihood.  The algorithm
 returns the estimated log-likelihood value, and saves
 unequally weighted samples from the posterior distribution of the latent
 states in the \code{mvWSamples} modelValues object, with corresponding logged weights in \code{mvWSamples['wts',]}.
 An equally weighted sample from the posterior can be found in the \code{mvEWsamp} \code{modelValues} object.
}
\examples{
\dontrun{
model <- nimbleModel(code = ...)
my_BootF <- buildBootstrapFilter(model, 'x[1:100]')
Cmodel <- compileNimble(model)
Cmy_BootF <- compileNimble(my_BootF, project = model)
logLike <- Cmy_BootF(m = 100000)
boot_X <- as.matrix(Cmy_BootF$mvEWSamples)
}
}
\author{
Daniel Turek and Nicholas Michaud
}
\references{
Gordon, N.J., D.J. Salmond, and A.F.M. Smith. (1993). Novel approach to nonlinear/non-Gaussian Bayesian state estimation. \emph{IEEE Proceedings F (Radar and Signal Processing)}. Vol. 140. No. 2. IET Digital Library, 1993.
}

