% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmp3xd4YE/filefb25d8e9933
\name{MultivariateNormal}
\alias{MultivariateNormal}
\alias{dmnorm_chol}
\alias{rmnorm_chol}
\title{The Multivariate Normal Distribution}
\usage{
dmnorm_chol(x, mean, cholesky, prec_param = TRUE, log = FALSE)

rmnorm_chol(n = 1, mean, cholesky, prec_param = TRUE)
}
\arguments{
\item{x}{vector of values.}\item{mean}{vector of values giving the mean of the distribution.}\item{cholesky}{upper-triangular Cholesky factor of either the precision matrix (when \code{prec_param} is TRUE) or covariance matrix (otherwise).}\item{prec_param}{logical; if TRUE the Cholesky factor is that of the precision matrix; otherwise, of the covariance matrix.}\item{log}{logical; if TRUE, probability density is returned on the log scale.}\item{n}{number of observations (only \code{n=1} is handled currently).}}\value{
\code{dmnorm_chol} gives the density and \code{rmnorm_chol} generates random deviates.
}
\description{
Density and random generation for the multivariate normal distribution, using the Cholesky factor of either the precision matrix or the covariance matrix.
}
\details{
See Gelman et al., Appendix A or the BUGS manual for mathematical details. The rate matrix as used here is defined as the inverse of the scale matrix, \eqn{S^{-1}}, given in Gelman et al.
}
\examples{
mean <- c(-10, 0, 10)
covmat <- matrix(c(1, .9, .3, .9, 1, -0.1, .3, -0.1, 1), 3)
ch <- chol(covmat)
x <- rmnorm_chol(1, mean, ch, prec_param = FALSE)
dmnorm_chol(x, mean, ch, prec_param = FALSE)
}
\author{
Christopher Paciorek
}
\references{
Gelman, A., Carlin, J.B., Stern, H.S., and Rubin, D.B. (2004) \emph{Bayesian Data Analysis}, 2nd ed. Chapman and Hall/CRC.
}
\seealso{
\link{Distributions} for other standard distributions
}

