% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{sig_sq}
\alias{sig_sq}
\title{Helper function to get sigma squared values for a given dataset}
\usage{
sig_sq(tree_data, model = "BM")
}
\arguments{
\item{tree_data}{a list of two elements (phy and data) resulted from using
the function \code{\link[geiger]{treedata}}. NOTE: data must be a single
vector (i.e., a single column).}

\item{model}{model to fit to comparative data; see
\code{\link[geiger]{fitContinuous}}. Default = "BM".}
}
\value{
the sigma squared value (evolutionary rate) for the data, given the
tree.
}
\description{
Sigma squared values for a single niche summary statistic
are calculated using \code{\link[geiger]{fitContinuous}}.
}
\examples{
# a simple tree
data("tree5", package = "nichevol")

# simple data
data <- rnorm(n = length(tree5$tip.label))
names(data) <- tree5$tip.label
# tree with data
treeWdata <- geiger::treedata(tree5, data)

# Estimating sigma squared for the dataset
sig_sq(treeWdata)
}
