% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztppp.R
\name{ztppp}
\alias{ztppp}
\title{Simulate a zero-truncated homogeneous Poisson Point Process over (t_min, t_max]}
\usage{
ztppp(rate, t_min, t_max, atmost1 = FALSE)
}
\arguments{
\item{rate}{(scalar, double) constant instantaneous rate}

\item{t_min}{(scalar, double) lower bound of the time interval}

\item{t_max}{(scalar, double) upper bound of the time interval}

\item{atmost1}{boolean, draw at most 1 event time}
}
\value{
a vector of event times of size \code{size}
}
\description{
Simulate a zero-truncated homogeneous Poisson Point Process over (t_min, t_max]
}
\examples{
x <- ztppp(t_min = 0, t_max = 10, rate = 0.001)
}
