% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vdraw_sc_step_regular.R
\name{vdraw_sc_step_regular}
\alias{vdraw_sc_step_regular}
\title{Vectorized sampling from NHPPPs with piecewise constant intensities
with same interval lengths (R)}
\usage{
vdraw_sc_step_regular(
  Lambda_matrix = NULL,
  lambda_matrix = NULL,
  range_t = c(0, 10),
  tol = 10^-6,
  atmost1 = FALSE,
  atleast1 = FALSE,
  use_cpp = TRUE
)
}
\arguments{
\item{Lambda_matrix}{(matrix) integrated intensity rates at the end of each interval}

\item{lambda_matrix}{(matrix) intensity rates, one per interval}

\item{range_t}{(vector, double) \code{t_min} and \code{t_max}}

\item{tol}{(scalar, double) tolerance for the number of events}

\item{atmost1}{boolean, draw at most 1 event time}

\item{atleast1}{boolean, draw at least 1 event time (zero-truncated NHPPP)}

\item{use_cpp}{(boolean, TRUE) use the C++ implementation of the function}
}
\value{
a vector of event times t
if no events realize, it will have 0 length
}
\description{
Simulate a piecewise constant-rate Poisson Point Process over \verb{(t_min, t_max]} (inversion method)
where the intervals have the same length (are "regular").
}
\examples{
x <- vdraw_sc_step_regular(Lambda_matrix = matrix(1:5, nrow = 1))
}
