% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_catchments.R
\name{rescale_catchment_characteristics}
\alias{rescale_catchment_characteristics}
\title{Rescale Catchment Characteristics}
\usage{
rescale_catchment_characteristics(
  vars,
  lookup_table,
  refactored_areas = NULL,
  catchment_characteristics = NULL,
  catchment_areas = NULL
)
}
\arguments{
\item{vars}{data.frame containing `characteristic_id` retrieved from
\link{get_characteristics_metadata} and `summary_statistic` indicating
which summary statistic should be applied to rescale each characteristic.
Accepted values are "sum," "length_weighted_mean," "area_weighted_mean,"
"min," and "max."}

\item{lookup_table}{data.frame containing `id` numeric vector of identifiers
at the desired scale; "comid" is a numeric vector of NHDPlusv2 identifiers;
"member_comid" contains formatted NHDPlusv2 COMIDs indicating that the
catchments in question need to be split. If catchments have not been split,
the columns "comid" and "member_comid" should be identical.}

\item{refactored_areas}{data.frame containing columns "featureid" and "areasqkm."
Used to retrieve adjusted catchment areas in the case of split catchments. If
not provided, either no split catchments can be considered or the `catchment_areas`
parameter is required.}

\item{catchment_characteristics}{data.frame containing columns
"characteristic_id", "comid", "characteristic_value", and "percent_nodata".
If not provided, it will be retrieved from \link{get_catchment_characteristics}
using the characteristic ids from `vars` and the comids from `lookup_table`.}

\item{catchment_areas}{data.frame containing columns "comid", "areasqkm",
"split_catchment_areasqkm", and "split_area_prop". If not provided, it will
be retrieved from `refactored_areas` and/or \link{get_vaa}.}
}
\description{
Given catchment characteristics to retrieve or process will
aggregate and / or split the characteristics according to a lookup table.
}
\details{
NOTE: Since this algorithm works on catchment characteristics that are
spatial averages, when splitting, the average condition is apportioned evenly
to each split. In some cases, such as with land cover or elevation, this may
not be appropriate and source data should be used to derive new characteristics.
In addition, this function handles catchment areas for split catchments but
makes no adjustments for the length of flowlines in those catchments.
Therefore, requests for length-weighted mean values may not be appropriate
when working with split catchments.
}
\examples{
\donttest{
vars <- data.frame(characteristic_id = c("CAT_IMPV11","CAT_BASIN_AREA"),
                   summary_statistic = c("area_weighted_mean","sum"))
lookup_table <- data.frame(id = rep(10012268, 2),
                           comid = c(4146596, 4147382),
                           member_comid = c(4146596, 4147382))
rescale_catchment_characteristics(vars, lookup_table)

vars <- data.frame(characteristic_id = c("CAT_ELEV_MIN","CAT_ELEV_MAX"),
                   summary_statistic = c("min","max"))
lookup_table <- data.frame(id = rep(10012268, 2),
                           comid = c(4146596, 4147382),
                           member_comid = c(4146596, 4147382))
rescale_catchment_characteristics(vars, lookup_table)

vars <- data.frame(characteristic_id = c("CAT_EWT","CAT_TWI", "CAT_BASIN_AREA"),
                   summary_statistic = c("area_weighted_mean", "area_weighted_mean","sum"))
lookup_table <- data.frame(id = c(10012268, 10012268, 10024047, 10024048),
                           comid = c(4146596, 4147382, 4147396, 4147396),
                           member_comid = c("4146596", "4147382", "4147396.1", "4147396.2"))
comid_areas <- data.frame(featureid = c("4146596", "4147382", "4147396.1", "4147396.2"),
                               areasqkm = c(0.9558, 11.9790, 6.513294, 1.439999))
rescale_catchment_characteristics(vars, lookup_table, refactored_areas = comid_areas)

 }

}
