% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhdplusTools.R
\name{st_compatibalize}
\alias{st_compatibalize}
\title{make spatial inputs compatible}
\usage{
st_compatibalize(sf1, sf2)
}
\arguments{
\item{sf1}{sf data.frame}

\item{sf2}{sf data.frame}
}
\description{
makes sf1 compatible with sf2 by projecting into
the projection of 2 and ensuring that the geometry columns are the
same name.
}
\examples{

source(system.file("extdata", "sample_flines.R", package = "nhdplusTools"))

(one <- dplyr::select(sample_flines))
(two <- sf::st_transform(one, 5070))

attr(one, "sf_column") <- "geotest"
names(one)[names(one) == "geom"] <- "geotest"

st_compatibalize(one, two)

}
