% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_plus_attributes.R
\name{add_plus_network_attributes}
\alias{add_plus_network_attributes}
\title{Add NHDPlus Network Attributes to a provided network.}
\usage{
add_plus_network_attributes(
  net,
  override = 5,
  cores = NULL,
  split_temp = NULL,
  status = TRUE
)
}
\arguments{
\item{net}{data.frame containing comid, tocomid, nameID, lengthkm, and areasqkm.
Additional attributes will be passed through unchanged.
tocomid == 0 is the convention used for outlets.
If a "weight" column is provided, it will be used in \link{get_levelpaths}
otherwise, arbolate sum is calculated for the network and used as the weight.}

\item{override}{numeric factor to be passed to \link{get_levelpaths}}

\item{cores}{integer number of processes to spawn if run in parallel.}

\item{split_temp}{character path to optional temporary copy of the network
split into independent sub-networks. If it exists, it will be read from disk
rather than recreated.}

\item{status}{logical should progress be printed?}
}
\value{
data.frame with added attributes
}
\description{
Given a river network with required base attributes, adds the
NHDPlus network attributes: hydrosequence, levelpath, terminalpath, pathlength,
down levelpath, down hydroseq, total drainage area, and terminalflag.
The function implements two parallelization schemes for small and large basins
respectively. If a number of cores is specified, parallel execution will be used.
}
\examples{

source(system.file("extdata", "walker_data.R", package = "nhdplusTools"))

test_flowline <- prepare_nhdplus(walker_flowline, 0, 0, FALSE)

test_flowline <- data.frame(
  comid = test_flowline$COMID,
  tocomid = test_flowline$toCOMID,
  nameID = walker_flowline$GNIS_ID,
  lengthkm = test_flowline$LENGTHKM,
  areasqkm = walker_flowline$AreaSqKM)

add_plus_network_attributes(test_flowline)
}
