% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesSearchVarName}
\alias{nhanesSearchVarName}
\title{Search for tables that contain a specified variable.}
\usage{
nhanesSearchVarName(varname = NULL, ystart = NULL, ystop = NULL,
  includerdc = FALSE, nchar = 100, namesonly = TRUE)
}
\arguments{
\item{varname}{Name of variable to match.}

\item{ystart}{Four digit year of first survey included in search, where ystart >= 1999.}

\item{ystop}{Four digit year of final survey included in search, where ystop >= ystart.}

\item{includerdc}{If TRUE then RDC only tables are included in list (default=FALSE).}

\item{nchar}{Truncates the variable description to a max length of nchar.}

\item{namesonly}{If TRUE then only the table names are returned (default=TRUE).}
}
\description{
Returns a list of table names that contain the variable
}
\details{
The NHANES Comprehensive Variable List is scanned to find all data tables that
contain the given variable name. Only a single variable name may be entered, and only
exact matches will be found.
}
\examples{
\donttest{nhanesSearchVarName('BMXLEG')}
\donttest{nhanesSearchVarName('BMXHEAD', ystart=2003)}
}

