% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes.R
\name{nhanesDXA}
\alias{nhanesDXA}
\title{Import Dual Energy X-ray Absorptiometry (DXA) data.}
\usage{
nhanesDXA(year, suppl = FALSE, destfile = NULL)
}
\arguments{
\item{year}{The year of the data to import, where 1999<=year<=2006.}

\item{suppl}{If TRUE then retrieve the supplemental data (default=FALSE).}

\item{destfile}{The name of a destination file. If NULL then the data are imported 
into the R environment but no file is created.}
}
\value{
By default the table is returned as a data frame. When downloading to file, the return argument
is the integer code from download.file where 0 means success and non-zero indicates failure to download.
}
\description{
DXA data were acquired from 1999-2006.
}
\details{
Provide destfile in order to write the data to file. If destfile is not provided then
the data will be imported into the R environment.
}
\examples{
\donttest{dxa_b <- nhanesDXA(2001)}
\donttest{dxa_c_s <- nhanesDXA(2003, suppl=TRUE)}
\donttest{nhanesDXA(1999, destfile="dxx.xpt")}
}

