% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{batch_file}
\alias{batch_file}
\title{Process the input file a batch of one batch}
\usage{
batch_file(filename = "", batch_lines = 1e+07, handler = NULL,
  param_names = c("x", "i"), extra_fread_params = list(sep = "\\n", header =
  FALSE, return_1L = TRUE), extra_params = list(), start_index = 1)
}
\arguments{
\item{filename}{Filename need to process}

\item{batch_lines}{Batch lines to process the data, default 10000000}

\item{handler}{The function to process the data}

\item{param_names}{Hander function required parameter names}

\item{extra_fread_params}{Extra fread parameters in read data step,
default is list(sep = '\\n', header = TRUE, return_1L = TRUE), return_1L to get x[[1L]]}

\item{extra_params}{Extra paramemters pass to handler function}

\item{start_index}{default is 1, control the skip rows, n = (i-1) * batch_lines}
}
\description{
Process the input file a batch of one batch
}
\examples{
dat <- data.frame(a=1:100, b=1:100)
filename <- tempfile()
write.table(dat, filename, sep = '\\t', row.names = FALSE, quote = FALSE)
handler_fun <- function(x, i = 1) {
  return(x[i])
}
batch_file(filename, 10, handler_fun)
}
