% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_tools}
\alias{set_tools}
\title{Function to generate tools path object}
\usage{
set_tools(config.file = "", config.list = list(), config.vec = c(),
  eval.params = list())
}
\arguments{
\item{config.file}{Path of tools configuration file (json, ini, yaml and toml be supported)}

\item{config.list}{List object of tools that all of tools path (exclude those without names).}

\item{config.vec}{Vector object of tools that all of tools path (exclude those without names).}

\item{eval.params}{Params pass to configr::eval.config}
}
\value{
List object contain the tools path that can be used by other function in ngstk package
}
\description{
Function to generate tools path object
}
\examples{
config.file <- system.file('extdata', 'demo/tools_config.json', package = 'ngstk')
config.list <- list(gatk = '/path/gatk')
config.vec <- c('/path/samtools')
names(config.vec) <- 'samtools'
tools <- set_tools(config.file, config.list, config.vec, 
                  eval.params = list(config = 'tools'))
}
