% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngram.r
\docType{methods}
\name{Tokenize}
\alias{Tokenize}
\alias{ngram}
\alias{ngram,character-method}
\alias{tokenize}
\title{n-gram Tokenization}
\usage{
ngram(str, n = 2, sep = " ")

\S4method{ngram}{character}(str, n = 2, sep = " ")
}
\arguments{
\item{str}{The input text.}

\item{n}{The 'n' as in 'n-gram'.}

\item{sep}{A set of separator characters for the "words".  See details for
information about how this works; it works a little differently
from \code{sep} arguments in R functions.}
}
\value{
An \code{ngram} class object.
}
\description{
The \code{ngram()} function is the main workhorse of this package.  It takes
an input string and converts it into the internal n-gram representation.
}
\details{
On evaluation, a copy of the input string is produced and stored as an
external pointer.  This is necessary because the internal list
representation just points to the first char of each word in the input
string.  So if you (or R's gc) deletes the input string, basically all hell
breaks loose.

The \code{sep} parameter splits at any of the characters in 
the string.  So \code{sep=", "} splits at a comma or a space.
}
\examples{
library(ngram)

str <- "A B A C A B B"
ngram(str, n=2)

str <- "A,B,A,C A B B"
### Split at a space
print(ngram(str), output="full")
### Split at a comma
print(ngram(str, sep=","), output="full")
### Split at a space or a comma
print(ngram(str, sep=", "), output="full")

}
\seealso{
\code{\link{ngram-class}}, \code{\link{getters}}, 
\code{\link{phrasetable}}, \code{\link{babble}}
}
\keyword{Tokenization}

