% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_injuries.R
\name{load_injuries}
\alias{load_injuries}
\title{Load Injury Reports}
\usage{
load_injuries(
  seasons = most_recent_season(),
  file_type = getOption("nflreadr.prefer", default = "rds")
)
}
\arguments{
\item{seasons}{a numeric vector of seasons to return, data available since 2009. Defaults to latest season available.}

\item{file_type}{One of \code{c("rds", "qs", "csv", "parquet")}. Can also be set globally with
\code{options(nflreadr.prefer)}}
}
\value{
a tibble of season-level injury report data.
}
\description{
Data collected from an API for weekly injury report data.
}
\examples{
\donttest{
try({# prevents cran errors
    load_injuries(2020)
})
}

}
\seealso{
\url{https://nflreadr.nflverse.com/articles/dictionary_injuries.html} for a web version of the dictionary

\code{\link{dictionary_injuries}} for the data dictionary as bundled within the package

Issues with this data should be filed here: \url{https://github.com/nflverse/nflverse-data}
}
