% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_player_stats.R
\name{load_player_stats}
\alias{load_player_stats}
\title{Load Official Game Stats}
\usage{
load_player_stats(qs = FALSE)
}
\arguments{
\item{qs}{Whether to use the function \code{\link[qs:qdeserialize]{qs::qdeserialize()}} for more efficient loading.}
}
\value{
Weekly stats for all passers, rushers and receivers in the nflfastR
play-by-play data from the 1999 season to the most recent season
}
\description{
Loads weekly stats for all passers, rushers and receivers in the
nflfastR play-by-play data from the 1999 season to the most recent season
}
\examples{
\donttest{
stats <- load_player_stats()
dplyr::glimpse(stats)
}
}
\seealso{
The function \code{\link[=calculate_player_stats]{calculate_player_stats()}} and the corresponding examples
on \href{https://www.nflfastr.com/articles/nflfastR.html#example-11-replicating-official-stats}{the nflfastR website}
}
