% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form.R
\name{textAreaInput}
\alias{textAreaInput}
\title{Create an advanced text area input}
\usage{
textAreaInput(
  inputId,
  label,
  value = "",
  width = NULL,
  height = NULL,
  cols = NULL,
  rows = NULL,
  placeholder = NULL,
  resize = c("both", "none", "vertical", "horizontal"),
  style = c("default", "pill", "round", "clean"),
  border.type = c("none", "primary", "secondary", "info", "success", "danger", "warning")
)
}
\arguments{
\item{inputId}{The identification name}

\item{label}{The label for the input}

\item{value}{The current value of the input}

\item{width}{width of the text input}

\item{height}{height of the text input}

\item{cols}{col of text to display}

\item{rows}{row of text to display}

\item{placeholder}{A placeholder text}

\item{resize}{Make inout resizable, with choices "both", "none", "vertical", "horizontal"}

\item{style}{Style to adapt, options include "default", "pill", "round", "clean"}

\item{border.type}{Add a border coloring using either of "none", "primary", "secondary", "info", "success", "danger", "warning"}
}
\value{
HTML element of a textAreaInput
}
\description{
Modifications to 'textAreaInput' to allow added styles
}
\note{
For more information on the features of the form, visit the examples section of the help documentation
}
\examples{
textAreaInput("caption",
          "Sample Text area input",
          "Data Summary",
          width = "1000px", border.type = "success"
        )


}
