% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sources.R
\name{get_sources}
\alias{get_sources}
\title{Returns selected sources from newsapi.org}
\usage{
get_sources(category = NULL, language = NULL, country = NULL,
  api_key = Sys.getenv("NEWS_API_KEY"))
}
\arguments{
\item{category}{Category you want to get sources for as a string. Default: NULL.}

\item{language}{The langauge you want to get sources for as a string. Default: NULL.}

\item{country}{The country you want to get sources for as a string (e.g. "us"). Default: NULL.}

\item{api_key}{String with the API key you get from newsapi.org. 
Passing it is compulsory. Alternatively, function can be 
provided from the global environment (see \code{set_api_key}).}
}
\value{
List with two dataframes:\cr
        1) Data frame with \code{results_df}\cr
        2) Data frame with \code{meta_data}
}
\description{
\code{get_sources} returns the news sources currently available on newsapi.org. 
The sources can be filtered using category, language or country. If the arguments are empty
the query return all available sources.
}
\examples{
\dontrun{
get_sources(api_key)
get_sources(api_key, category = "technology")
get_sources(api_key, language = "en")
}

}
