% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{plot.nvd}
\alias{plot.nvd}
\title{MDS Visualization of Network Distributions}
\usage{
\method{plot}{nvd}(x, y, ...)
}
\arguments{
\item{x}{A \code{\link{nvd}} object.}

\item{y}{A \code{\link{nvd}} object.}

\item{...}{Extra arguments to be passed to the plot function.}
}
\value{
Invisibly returns a \code{\link[ggplot2]{ggplot}} object. In
particular, the data set computed to generate the plot can be retrieved via
\verb{$data}. This is a \code{\link[tibble]{tibble}} containing the following
variables:
\itemize{
\item \code{V1}: the x-coordinate of each observation in the plane,
\item \code{V2}: the y-coordinate of each observation in the plane,
\item \code{Label}: the sample membership of each observation,
\item \code{Representation}: the type of matrix representation used to manipulate each
observation,
\item \code{Distance}: the distance used to measure how far each observation is from
the others.
}
}
\description{
This function generates 2-dimensional plots of samples of networks via
multi-dimensional scaling using all representations and distances included in
the package.
}
\examples{
x <- nvd("smallworld", 10)
y <- nvd("pa", 10)
plot(x, y)
}
