% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nvd-class.R
\name{nvd}
\alias{nvd}
\title{Network-Valued Data Constructor}
\usage{
nvd(
  model = "smallworld",
  n = 0L,
  pref.matrix = NULL,
  lambda = NULL,
  size = NULL,
  prob = NULL
)
}
\arguments{
\item{model}{A string specifying the model to be used for sampling networks
(current choices are: \code{"sbm"}, \code{"k_regular"}, \code{"gnp"},
\code{"smallworld"}, \code{"pa"}, \code{"poisson"} and \code{"binomial"}).
Default is \code{"smallworld"}.}

\item{n}{An integer specifying the sample size (default: \code{0L}).}

\item{pref.matrix}{A matrix giving the Bernoulli rates for the SBM generator
(see \code{\link[igraph]{sample_sbm}} for details). Default is \code{NULL}.
It is required for \code{model == "sbm"}.}

\item{lambda}{A numeric value specifying the mean value for the Poisson
generator. Default is \code{NULL}. It is required for \code{model ==
  "poisson"}.}

\item{size}{An integer value specifying the number of trials for the binomial
distribution. Default is \code{NULL}. It is required for \code{model ==
  "binomial"}.}

\item{prob}{A numeric value specifying the probability of success of each
trial for the binomial distribution. Default is \code{NULL}. It is required
for \code{model == "binomial"}.}
}
\value{
A \code{nvd} object which is a list of \code{\link[igraph]{igraph}}
objects.
}
\description{
This is the constructor for objects of class \code{nvd}.
}
\examples{
nvd(n = 10L)
}
