% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{neutralitytest}
\alias{neutralitytest}
\title{Testing for neutrality on cancer sequencing data}
\usage{
neutralitytest(VAF, fmin = 0.12, fmax = 0.24)
}
\arguments{
\item{VAF}{Vector of variant allele frequencies (VAFs) from a deep sequencing experiment,
numbers should be between 0 and 1}

\item{fmin}{Minimum VAF of integration range, default is 0.12}

\item{fmax}{Maximum VAF of integration range, default is 0.24}
}
\value{
neutralitytest object which contains test statistics which tests
if the sequencing data is consistent a neutral evolutionary model.
Test statistics are area between theoretical and empirical curves, kolmogorov distance, mean distance and R^2 statistics
from linear model fit. Also returns an estimate of the mutation rate per tumour tumour doubling, the raw VAFs and
cumulative distribution
}
\description{
\code{neutralitytest} returns a neutralitytest object which contains the result of
various test statistics to test for neutrality as described in Williams et al. Nature Genetics 2018.
}
\examples{
neutralitytest(runif(100))
neutralitytest(VAFselection, fmin = 0.1, fmax = 0.25)
}
