% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/file_format.R
\name{read_meta_info}
\alias{read_meta_info}
\alias{read_meta_info,NIFTIFormat-method}
\alias{read_meta_info,AFNIFormat-method}
\title{Generic function to read image meta info given a file}
\usage{
read_meta_info(x, file_name)

\S4method{read_meta_info}{NIFTIFormat}(x, file_name)

\S4method{read_meta_info}{AFNIFormat}(x, file_name)
}
\arguments{
\item{x}{A \linkS4class{FileFormat} object (either NIFTIFormat or AFNIFormat)}

\item{file_name}{A character string specifying the file name to read meta
information from}
}
\value{
A \code{list} containing the meta information read from the file.

An object of class \linkS4class{NIFTIMetaInfo} or \linkS4class{AFNIMetaInfo},
  depending on the input format
}
\description{
Reads meta information from image files based on their format (NIFTI or AFNI).
}
\details{
These methods use format-specific functions to read the header information and
create the appropriate meta information object. The `.read_meta_info` helper
function is used internally to streamline the process for both formats.
}
\examples{
# Create a NIFTI format descriptor
fmt <- new("NIFTIFormat",
           file_format = "NIFTI",
           header_encoding = "raw",
           header_extension = "nii",
           data_encoding = "raw",
           data_extension = "nii")

# Read metadata from a NIFTI file
\donttest{
fname <- system.file("extdata", "global_mask_v4.nii", package="neuroim2")
meta <- read_meta_info(fmt, fname)

# Access metadata properties
dim(meta)          # Image dimensions
trans(meta)        # Transformation matrix
}

}
