% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainSlice.R, R/BrainSpace.R, R/BrainVolume.R
\docType{methods}
\name{indexToGrid}
\alias{indexToGrid}
\alias{indexToGrid,BrainSlice,index-method}
\alias{indexToGrid,BrainSpace,index-method}
\alias{indexToGrid,BrainVector,index-method}
\alias{indexToGrid,BrainVolume,index-method}
\title{Generic function to convert 1D indices to N-dimensional grid coordinates}
\usage{
indexToGrid(x, idx)

\S4method{indexToGrid}{BrainSlice,index}(x, idx)

\S4method{indexToGrid}{BrainSpace,index}(x, idx)

\S4method{indexToGrid}{BrainVector,index}(x, idx)

\S4method{indexToGrid}{BrainVolume,index}(x, idx)
}
\arguments{
\item{x}{the object}

\item{idx}{the 1D \code{vector} of indices}
}
\value{
a matrix of grid coordinates
}
\description{
Generic function to convert 1D indices to N-dimensional grid coordinates
}
\examples{
bvol <- BrainVolume(array(0, c(10,10,10)), BrainSpace(c(10,10,10), c(1,1,1)))
 idx <- 1:10
 g <- indexToGrid(bvol, idx)
 bvol[g]
}

