% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BrainRegion3D.R
\name{RegionSphere}
\alias{RegionSphere}
\title{Create A Spherical Region of Interest}
\usage{
RegionSphere(bvol, centroid, radius, fill = NULL, nonzero = FALSE)
}
\arguments{
\item{bvol}{an \code{BrainVolume} or \code{BrainSpace} instance}

\item{centroid}{the center of the sphere in voxel space}

\item{radius}{the radius in real units (e.g. millimeters) of the spherical ROI}

\item{fill}{optional value(s) to assign to data slot}

\item{nonzero}{keep only nonzero elements from \code{bvol}}
}
\value{
an instance of class \code{ROIVolume}
}
\description{
Create A Spherical Region of Interest
}
\examples{
sp1 <- BrainSpace(c(10,10,10), c(1,1,1))
 cube <- RegionSphere(sp1, c(5,5,5), 3.5)
 vox = coords(cube)
}

