\name{sim.fmri.ts}
\alias{sim.fmri.ts}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Simulate fMRI time series
}
\description{Simulates an fMRI time series for the specified design and noise type.
}
\usage{
sim.fmri.ts(design = list(), nscan = NULL, TR = NULL, SNR, noise = c("none", "white", "temporal", "low-frequency", "physiological", "task-related", "mixture"), temp = c("AR(1)", "state-space"), weights, verbose = TRUE, rho = NULL, lowfreq = NULL, heartfreq = NULL, respfreq = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{design}{List generated by \code{\link{simprep.act.temp}} specifying the design. If not specified, noise time series are generated.
}
  \item{nscan}{Number of scans.
}
  \item{TR}{Repetition time in seconds.
}
  \item{SNR}{Signal-to-noise ratio of the time series.
}
  \item{noise}{Type of noise (white is default).
}
  \item{temp}{If noise=temporal, type of temporal noise (AR(1) is default).
}
  \item{weights}{If noise=mixture, vector of weights with 5 elements to specify the fraction of the noise components.
}
  \item{verbose}{Logical indicating if warnings should be returned.
}
  \item{rho}{If noise=temporal or noise=mixture, value of autocorrelation coefficient.
}
  \item{lowfreq}{If noise=low-frequency or noise=mixture, frequency of the low-frequency drift in seconds.
}
  \item{heartfreq}{If noise=physiological or noise=mixture, frequency of heart rate in Hz.
}
  \item{respfreq}{If noise=physiological or noise=mixture, frequency of respiratory rate in Hz.
}
}
\value{A vector representing the fMRI time series.
}
\author{M. Welvaert
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{\code{\link{sim.fmri.data}}, \code{\link{simprep.act.temp}}
}
\examples{
rm(list=ls())
design <- simprep.act.temp(T=200, ncond=1, onsets=seq(1,200,40), durations=20, TR=2, acc=0.1, hrf="double-gamma")
ts <- sim.fmri.ts(design=design, SNR=1, noise="white")
#plot(ts, type="l")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ high-level }
