% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/forceNetwork.R
\name{forceNetwork}
\alias{forceNetwork}
\title{Create a D3 JavaScript force directed network graph.}
\source{
D3.js was created by Michael Bostock. See \url{http://d3js.org/} and, more
specifically for force directed networks
\url{https://github.com/mbostock/d3/wiki/Force-Layout}.
}
\usage{
forceNetwork(Links, Nodes, Source, Target, Value, NodeID, Group,
  height = NULL, width = NULL, colourScale = "d3.scale.category20()",
  fontsize = 7, linkDistance = 50,
  linkWidth = "function(d) { return Math.sqrt(d.value); }", charge = -120,
  linkColour = "#666", opacity = 0.6)
}
\arguments{
\item{Links}{a data frame object with the links between the nodes. It should
include the \code{Source} and \code{Target} for each link. These should be
numbered starting from 0. An optional \code{Value} variable can be included
to specify how close the nodes are to one another.}

\item{Nodes}{a data frame containing the node id and properties of the nodes.
If no ID is specified then the nodes must be in the same order as the Source
variable column in the \code{Links} data frame. Currently only a grouping
variable is allowed.}

\item{Source}{character string naming the network source variable in the
\code{Links} data frame.}

\item{Target}{character string naming the network target variable in the
\code{Links} data frame.}

\item{Value}{character string naming the variable in the \code{Links} data
frame for how wide the links are.}

\item{NodeID}{character string specifying the node IDs in the \code{Nodes}
data frame.}

\item{Group}{character string specifying the group of each node in the
\code{Nodes} data frame.}

\item{height}{numeric height for the network graph's frame area in pixels.}

\item{width}{numeric width for the network graph's frame area in pixels.}

\item{colourScale}{character string specifying the categorical colour
scale for the nodes. See
\url{https://github.com/mbostock/d3/wiki/Ordinal-Scales}.}

\item{fontsize}{numeric font size in pixels for the node text labels.}

\item{linkDistance}{numeric or character string. Either numberic fixed
distance between the links in pixels (actually arbitrary relative to the
diagram's size). Or a JavaScript function, possibly to weight by
\code{Value}. For example:
\code{linkDistance = "function(d){return d.value * 10}"}.}

\item{linkWidth}{numeric or character string. Can be a numeric fixed width in
pixels (arbitrary relative to the diagram's size). Or a JavaScript function,
possibly to weight by \code{Value}. The default is
\code{linkWidth = "function(d) { return Math.sqrt(d.value); }"}.}

\item{charge}{numeric value indicating either the strength of the node
repulsion (negative value) or attraction (positive value).}

\item{linkColour}{character string specifying the colour you want the link
lines to be. Multiple formats supported (e.g. hexadecimal).}

\item{opacity}{numeric value of the proportion opaque you would like the
graph elements to be.}
}
\description{
Create a D3 JavaScript force directed network graph.
}
\examples{
#### Tabular data example.
# Load data
data(MisLinks)
data(MisNodes)

# Create graph
forceNetwork(Links = MisLinks, Nodes = MisNodes, Source = "source",
             Target = "target", Value = "value", NodeID = "name",
             Group = "group", opacity = 0.4)

\dontrun{
#### JSON Data Example
# Load data JSON formated data into two R data frames
library(RCurl)
MisJson <- getURL("http://bit.ly/1cc3anB")
MisLinks <- JSONtoDF(jsonStr = MisJson, array = "links")
MisNodes <- JSONtoDF(jsonStr = MisJson, array = "nodes")

# Create graph
forceNetwork(Links = MisLinks, Nodes = MisNodes, Source = "source",
             Target = "target", Value = "value", NodeID = "name",
             Group = "group", opacity = 0.4)
}
}

